<?php
session_start();
require '../conexao.php';

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location: ../login.php");
}

if (isset($_POST['criarOrdem'])) {
    // Receba os parâmetros do formulário
    $quantidade = $_POST['quantidade'];
    $valor = $_POST['valor'];
    $userwallet = $_POST['userwallet'];
    $user_id = $_SESSION['user_name'];
    $dataehora = $_POST['dataehora'];
$saldo = $_SESSION['saldolivre2'];
 $pin = $_SESSION['user_pin'];
    $postpin = $_POST['pin'];


    
    // Verificar PIN
    if (!password_verify($postpin, $pin)) {
        $_SESSION['mensagem'] = 'Erro: PIN incorreto.';
        header('Location: ../dashboard.php');
        exit;
    }

if (0 < 2) {
$qntxvalor = bcmul($valor, $quantidade, 2); // O "2" define 2 casas decimais
};

if ($saldo < $qntxvalor) {
$_SESSION['msg'] = "Você não tem R$ $qntxvalor pra comprar $quantidade unidades por $valor.";
     
           header("Location: ordenscompra.php");
        
        exit;
    }
    
    
   // xxxxxxxxxxxxx xxxxxxxxxxxxx
$valorMaximo = $_POST['valor']; // Valor máximo da ordem de compra
$quantidadeDesejada = $_POST['quantidade']; // Quantidade da ordem de compra
$jogadorLogado = $_SESSION['user_name']; // Jogador logado

// Consulta para buscar personagens à venda (excluindo o jogador logado)
$sqlPersonagens = "SELECT id, jogador, personagem AS nome, valor, dataehora, 1 AS quantidade, 'personagem' AS tipo 
                   FROM ordem_vendas 
                   WHERE valor <= :valorMaximo AND jogador != :jogadorLogado";

// Consulta para buscar fichas à venda (excluindo o jogador logado)
$sqlFichas = "SELECT id, jogador, quantidade, preco AS valor, data AS dataehora, 'ficha' AS tipo 
              FROM fichaspersonagens 
              WHERE preco <= :valorMaximo AND situacao = 'vendendo' AND jogador != :jogadorLogado";

// Preparar e executar as consultas
$stmtPersonagens = $pdo->prepare($sqlPersonagens);
$stmtPersonagens->bindParam(':valorMaximo', $valorMaximo, PDO::PARAM_STR);
$stmtPersonagens->bindParam(':jogadorLogado', $jogadorLogado, PDO::PARAM_STR);
$stmtPersonagens->execute();
$personagens = $stmtPersonagens->fetchAll(PDO::FETCH_ASSOC);

$stmtFichas = $pdo->prepare($sqlFichas);
$stmtFichas->bindParam(':valorMaximo', $valorMaximo, PDO::PARAM_STR);
$stmtFichas->bindParam(':jogadorLogado', $jogadorLogado, PDO::PARAM_STR);
$stmtFichas->execute();
$fichas = $stmtFichas->fetchAll(PDO::FETCH_ASSOC);

// Combinar os resultados
$resultados = array_merge($personagens, $fichas);

// Ordenar os resultados pelo menor valor e pela data mais antiga
usort($resultados, function ($a, $b) {
    if ($a['valor'] == $b['valor']) {
        return strtotime($a['dataehora']) - strtotime($b['dataehora']);
    }
    return $a['valor'] <=> $b['valor'];
});

// xxxxxxxxXXXXXXXXXXXXXXXXXXXXXXxxxx                    xxxxxxxxxxxxxxxxxxxx
// Se não houver ofertas disponíveis, CRIAR ORDEM DE COMPRA COM $QUANTIDADE E VALOR
if (empty($resultados) && empty($fichas)) {
    echo "Não há ordens de venda disponíveis 11.";
   // Verifica se não há ordens de venda disponíveis
// Verifica se não há ordens de venda disponíveis
if (empty($resultados)) {
    // Inserir os valores na tabela "ordens_compra"
    $sqlOrdemCompra = "INSERT INTO ordens_compra (quantidade, valor, wallet, user, dataehora) 
                       VALUES (:quantidade, :valor, :userwallet, :user_id, :dataehora)";
    $stmtOrdemCompra = $pdo->prepare($sqlOrdemCompra);
    $stmtOrdemCompra->bindValue(':quantidade', $quantidade, PDO::PARAM_INT);
    $stmtOrdemCompra->bindValue(':valor', $valor, PDO::PARAM_STR);
    $stmtOrdemCompra->bindValue(':userwallet', $userwallet, PDO::PARAM_STR);
    $stmtOrdemCompra->bindValue(':user_id', $user_id, PDO::PARAM_STR);
    $stmtOrdemCompra->bindValue(':dataehora', $dataehora, PDO::PARAM_STR);

    if ($stmtOrdemCompra->execute()) {
        echo "Ordem de compra criada com sucesso.<br>";

        // Obtém o ID da ordem de compra criada
        $idOrdemCompra = $pdo->lastInsertId();

        // Monta o relatório
        $informacaoRelatorio = "O {$_SESSION['user_name']} executou uma ordem de compra na quantidade de $quantidade e no valor de R$ " . number_format($valor, 2, ',', '.') . 
                               ", na data $dataehora, e não havia ordens de venda compatíveis. Então foram listadas as ordens de compra, de id $idOrdemCompra.";

        // Insere o relatório na tabela infossistema
        $sqlRelatorio = "INSERT INTO infossistema (informacao, p1, p2, origem, dataehora) 
                         VALUES (:informacao, :p1, :p2, :origem, :dataehora)";
        $stmtRelatorio = $pdo->prepare($sqlRelatorio);
        $stmtRelatorio->bindValue(':informacao', $informacaoRelatorio, PDO::PARAM_STR);
        $stmtRelatorio->bindValue(':p1', $_SESSION['user_name'], PDO::PARAM_STR); // Jogador logado
        $stmtRelatorio->bindValue(':p2', '', PDO::PARAM_STR); // Campo vazio (não há vendedor)
        $stmtRelatorio->bindValue(':origem', 'Ordem de compra', PDO::PARAM_STR);
        $stmtRelatorio->bindValue(':dataehora', date('Y-m-d H:i:s'), PDO::PARAM_STR);

        if ($stmtRelatorio->execute()) {
            echo "Relatório enviado para o sistema com sucesso.<br>";
        } else {
            echo "Erro ao enviar relatório: " . $stmtRelatorio->errorInfo()[2] . "<br>";
        }
    } else {
        echo "Erro ao criar a ordem de compra: " . $stmtOrdemCompra->errorInfo()[2] . "<br>";
    }

    // Inserir os valores na tabela "mempool"
    $sqlMempool = "INSERT INTO mempool (remetente, valor, dataehora, referencia) 
                   VALUES (:remetente, :valor, :dataehora, :referencia)";
    $stmtMempool = $pdo->prepare($sqlMempool);
    $stmtMempool->bindValue(':remetente', $userwallet, PDO::PARAM_STR);
    $stmtMempool->bindValue(':valor', $qntxvalor, PDO::PARAM_STR);
    $stmtMempool->bindValue(':dataehora', $dataehora, PDO::PARAM_STR);
    $referencia = "Ordem de comprar $quantidade por R$ $valor (R$ $qntxvalor) criada em $dataehora";
    $stmtMempool->bindValue(':referencia', $referencia, PDO::PARAM_STR);

    if ($stmtMempool->execute()) {
        echo "Dados inseridos na tabela mempool com sucesso.<br>";
    } else {
        echo "Erro ao inserir dados na tabela mempool: " . $stmtMempool->errorInfo()[2] . "<br>";
    }

    // Redireciona o usuário com uma mensagem de sucesso
    $_SESSION['msg'] = "Ordem de compra de $quantidade NFT's, por R$ $valor foi criada com sucesso.";
    header("Location: ordenscompra.php");
    exit;


    // XXXXXXXXXXxxxxxxxxxxxxxxxxxx          xxxxxxxxxxXXXXXXXXXX

    // EXIT FECHANDO O IF SE NÃO TIVER OFERTAS DISPONIVEIS
    exit;
}
}

// Contar a quantidade total disponível somando personagens (cada um vale 1) e fichas disponíveis
$quantidadeDisponivel = 0;
foreach ($resultados as $item) {
    $quantidadeDisponivel += ($item['tipo'] == 'ficha') ? $item['quantidade'] : 1;
}

// Exibir os resultados
foreach ($resultados as $item) {
    echo "Tipo: " . ucfirst($item['tipo']) . "<br>";
    echo "Vendedor: " . $item['jogador'] . "<br>";
    echo "Nome: " . $item['nome'] . "<br>";
    echo "Valor: R$ " . number_format($item['valor'], 2, ',', '.') . "<br>";
    echo "Data: " . $item['dataehora'] . "<br>";
    echo "Quantidade: " . (($item['tipo'] == 'ficha') ? $item['quantidade'] : 1) . "<br><br>";
}







// xxxxxxxxxxxxxxxxxx xxxxxxxxxx



// Verifica se há quantidade suficiente
if ($quantidadeDisponivel >= $quantidadeDesejada) {
        
    
    echo "Há personagens/fichas suficientes para suprir toda a demanda.";
} else {
    $quantidadeFaltante = $quantidadeDesejada - $quantidadeDisponivel;
    echo "Não há personagens/fichas suficientes para suprir toda a demanda. Você quer $quantidadeDesejada, existe $quantidadeDisponivel disponiveis e e Faltam $quantidadeFaltante para completar a compra.";
}
echo "<br><br>";



// xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxxxxxxxxx

// Consulta para buscar as ofertas (tanto fichas quanto personagens) de valor menor ou igual ao valor da compra
$sqlOfertas = "
    (SELECT 'ficha' AS tipo, descricao, preco AS valor FROM fichaspersonagens WHERE preco <= :valor AND situacao = 'vendendo' AND jogador != :user_name)
    UNION
    (SELECT 'personagem' AS tipo, personagem AS descricao, valor FROM ordem_vendas WHERE valor <= :valor AND jogador != :user_name)
    ORDER BY valor ASC
";

// Prepara a consulta
$stmtOfertas = $pdo->prepare($sqlOfertas);
$stmtOfertas->bindParam(':valor', $valor, PDO::PARAM_STR);
$stmtOfertas->bindParam(':user_name', $_SESSION['user_name'], PDO::PARAM_STR);

// Executa a consulta
$stmtOfertas->execute();

// Obtém as ofertas encontradas
$ofertas = $stmtOfertas->fetchAll(PDO::FETCH_ASSOC);

// Verifique se existem ofertas
if ($quantidadeDisponivel >= 1 && count($resultados) > 0) {
    // Inicializa variáveis para contar ofertas e calcular o total
    $ofertasEncontradas = 0;
    $totalGasto = 0;

    // Loop para iterar sobre as ofertas encontradas (tanto fichas quanto personagens)
    foreach ($ofertas as $oferta) {
        // A oferta pode ser de fichas ou personagens, então calculamos o valor gasto
        $ofertasEncontradas++;
        $totalGasto += $oferta['valor']; // Assume que cada 'oferta' tem um campo 'valor' representando o preço

        // Exibe os detalhes da oferta (ficha/personagem)
        echo "Oferta encontrada: " . $oferta['descricao'] . " - Valor: R$ " . $oferta['valor'] . "<br>";
    }

    // Exibe o número de ofertas encontradas e o total gasto
    echo "<br><b>Total de ofertas encontradas:</b> $ofertasEncontradas<br>";
    echo "<b>Total a ser gasto:</b> R$ " . number_format($totalGasto, 2, ',', '.') . "<br>";
} else {
    echo "Não há ofertas disponíveis no valor que você está procurando.";
}





// xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxxx
// xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxxx
                                
                    // Inserir os valores na tabela "ordens_compra"
                        $sqlOrdemCompra = "INSERT INTO ordens_compra (quantidade, valor, wallet, user, dataehora) VALUES (:quantidade, :valor, :userwallet, :user_id, :dataehora)";
                        $stmtOrdemCompra = $pdo->prepare($sqlOrdemCompra);
                        $stmtOrdemCompra->bindParam(':quantidade', $quantidadeFaltante, PDO::PARAM_INT);
                        $stmtOrdemCompra->bindParam(':valor', $valor, PDO::PARAM_STR);
                        $stmtOrdemCompra->bindParam(':userwallet', $userwallet, PDO::PARAM_STR);
                        $stmtOrdemCompra->bindParam(':user_id', $user_id, PDO::PARAM_STR);
                        $stmtOrdemCompra->bindParam(':dataehora', $dataehora, PDO::PARAM_STR);

                        if ($stmtOrdemCompra->execute()) {
                            // Dados da ordem de compra inseridos com sucesso
                        } else {
                            echo "Erro ao criar a ordem de compra: " . $stmtOrdemCompra->errorInfo()[2];
                        }

                        $novovalor = $valor * $quantidadeFaltante;



                    // Inserir os valores inserido da ordem de compra, na tabela "mempool"
                        $sqlMempool = "INSERT INTO mempool (remetente, valor, dataehora, referencia) VALUES (:remetente, :valor, :dataehora, :referencia)";
                        $stmtMempool = $pdo->prepare($sqlMempool);
                        $stmtMempool->bindParam(':remetente', $userwallet, PDO::PARAM_STR);
                        $stmtMempool->bindParam(':valor', $novovalor, PDO::PARAM_STR);
                        $stmtMempool->bindParam(':dataehora', $dataehora, PDO::PARAM_STR);
                        $referencia = "Ordem de comprar $quantidade por R$ $valor (R$ $qntxvalor) criada em $dataehora";
                        $stmtMempool->bindParam(':referencia', $referencia, PDO::PARAM_STR);

                        if ($stmtMempool->execute()) {
                            // Dados inseridos na tabela mempool com sucesso
                        } else {
                            echo "Erro ao inserir dados dAA ORDEM DE COMPRA na tabela mempool: " . $stmtMempool->errorInfo()[2];
                        }




        // xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxxx
        // INSERIR NA MEMPOL
        // Verifique se existem ofertas e se há quantidade suficiente
        if ($quantidadeDisponivel >= 1 && count($resultados) > 0) {
            // Inicializa variáveis para contar ofertas e calcular o total
            $ofertasEncontradas = 0;
            $totalGasto = 0;

            // Loop para iterar sobre as ofertas encontradas (tanto fichas quanto personagens)
            foreach ($resultados as $oferta) {
                // Verifica se já atingiu a quantidade desejada
                if ($quantidadeDesejada <= 0) {
                    break;
                }
            
                // Define a quantidade a ser comprada nesta iteração
                if ($oferta['tipo'] == 'ficha') {
                    // Para fichas, compra a quantidade disponível ou a quantidade desejada, o que for menor
                    $quantidadeComprada = min($oferta['quantidade'], $quantidadeDesejada);
                    $quantidadeDesejada -= $quantidadeComprada; // Atualiza a quantidade desejada
                } else {
                    // Para personagens, compra 1 unidade
                    $quantidadeComprada = 1;
                    $quantidadeDesejada -= 1; // Atualiza a quantidade desejada
                }

                // Busca a carteira do vendedor na tabela usersblock
                $sqlWalletVendedor = "SELECT wallet FROM usersblock WHERE user = :vendedor";
                $stmtWalletVendedor = $pdo->prepare($sqlWalletVendedor);
                $stmtWalletVendedor->bindParam(':vendedor', $oferta['jogador'], PDO::PARAM_STR);
                $stmtWalletVendedor->execute();
                $walletVendedor = $stmtWalletVendedor->fetchColumn();

               
                // Calcula o valor total da transação
                $valorTransacao = bcmul($oferta['valor'], $quantidadeComprada, 2);

                // Define a referência da transação com nome do comprador e vendedor
                $referencia = ($oferta['tipo'] == 'ficha') 
                    ? "Ficha comprada por {$_SESSION['user_name']} (Comprador) de {$oferta['jogador']} (Vendedor) em " . date('Y-m-d H:i:s') 
                    : "Personagem {$oferta['nome']} comprado por {$_SESSION['user_name']} (Comprador) de {$oferta['jogador']} (Vendedor) pela ordem de compra, realizada em " . date('Y-m-d H:i:s');

                // Insere a transação na tabela mempool
                $sqlMempool = "INSERT INTO mempool (destinatario, remetente, valor, dataehora, referencia) 
                            VALUES (:destinatario, :remetente, :valor, :dataehora, :referencia)";
                $stmtMempool = $pdo->prepare($sqlMempool);
                $stmtMempool->bindParam(':destinatario', $walletVendedor, PDO::PARAM_STR);
                $stmtMempool->bindParam(':remetente', $userwallet, PDO::PARAM_STR);
                $stmtMempool->bindParam(':valor', $valorTransacao, PDO::PARAM_STR);
                $stmtMempool->bindParam(':dataehora', date('Y-m-d H:i:s'), PDO::PARAM_STR); // Data e hora atual
                $stmtMempool->bindParam(':referencia', $referencia, PDO::PARAM_STR);

                if ($stmtMempool->execute()) {
                    // Transação inserida com sucesso
                    $ofertasEncontradas++;
                    $totalGasto += $valorTransacao;
                 //   $quantidadeDesejada -= $quantidadeComprada;

                    // Atualiza o saldo do comprador (opcional, dependendo da lógica do seu sistema)
                    $_SESSION['saldolivre2'] -= $valorTransacao;

                    // Exibe os detalhes da oferta (ficha/personagem)
                    echo "Transação realizada: " . $referencia . " - Valor: R$ " . number_format($valorTransacao, 2, ',', '.') . "<br>";






                // xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxxx
            // --- CÓDIGO PARA ENVIAR NOTIFICAÇÃO ---
            $tipoNotificacao = ($oferta['tipo'] == 'ficha') ? "Ficha vendida" : "Personagem vendido";
            $mensagemNotificacao = ($oferta['tipo'] == 'ficha') 
                ? "Ficha listada para venda, foi vendida pelo valor de R$ {$oferta['valor']} para uma ordem de compra na data de " . date('Y-m-d H:i:s') 
                : "Personagem {$oferta['nome']} listado para venda, foi vendido pelo valor de R$ {$oferta['valor']} para uma ordem de compra na data de " . date('Y-m-d H:i:s');

            $sqlNotificacao = "INSERT INTO notificacoes_sis (tipo, notificacao, user1, user2, dataehora, vz1, vz2, apg) 
                               VALUES (:tipo, :notificacao, :user1, :user2, :dataehora, 0, 0, 0)";
            $stmtNotificacao = $pdo->prepare($sqlNotificacao);
            $stmtNotificacao->bindParam(':tipo', $tipoNotificacao, PDO::PARAM_STR);
            $stmtNotificacao->bindParam(':notificacao', $mensagemNotificacao, PDO::PARAM_STR);
            $stmtNotificacao->bindParam(':user1', $_SESSION['user_name'], PDO::PARAM_STR); // Usuário logado (comprador)
            $stmtNotificacao->bindParam(':user2', $oferta['jogador'], PDO::PARAM_STR); // Vendedor
            $stmtNotificacao->bindParam(':dataehora', date('Y-m-d H:i:s'), PDO::PARAM_STR); // Data e hora atual

            if ($stmtNotificacao->execute()) {
                echo "Notificação enviada para {$oferta['jogador']}.<br>";
            } else {
                echo "Erro ao enviar notificação: " . $stmtNotificacao->errorInfo()[2] . "<br>";
            }

        } else {
            echo "Erro ao inserir transação na mempool: " . $stmtMempool->errorInfo()[2];
        }



        // XXXXXXXXXXXXXXXXXX    XXXXXXXXXXXX
            //TRANSFERIR FICHA Que tão vendedo, para o comprador/ usuario logado
                // Verifica se a oferta é uma ficha
        if ($oferta['tipo'] == 'ficha') {
            // Atualiza a ficha na tabela fichaspersonagens
            $sqlTransferirFicha = "UPDATE fichaspersonagens 
                                SET situacao = '1', jogador = :novo_jogador 
                                WHERE id = :id_ficha";
            $stmtTransferirFicha = $pdo->prepare($sqlTransferirFicha);
            $stmtTransferirFicha->bindParam(':novo_jogador', $_SESSION['user_name'], PDO::PARAM_STR); // Novo dono (comprador)
            $stmtTransferirFicha->bindParam(':id_ficha', $oferta['id'], PDO::PARAM_INT); // ID da ficha

            if ($stmtTransferirFicha->execute()) {
                echo "Ficha transferida para {$_SESSION['user_name']} com sucesso.<br>";
            } else {
                echo "Erro ao transferir ficha: " . $stmtTransferirFicha->errorInfo()[2] . "<br>";
            }




            



}
// xxxxxxxxxxxxxxxx

// Verifica se a oferta é um personagem
if ($oferta['tipo'] == 'personagem') {
    // Atualiza o personagem na tabela personagens
    $sqlTransferirPersonagem = "UPDATE personagens 
                                SET jogador = :novo_jogador 
                                WHERE personagem = :nome_personagem";
    $stmtTransferirPersonagem = $pdo->prepare($sqlTransferirPersonagem);
    $stmtTransferirPersonagem->bindParam(':novo_jogador', $_SESSION['user_name'], PDO::PARAM_STR); // Novo dono (comprador)
    $stmtTransferirPersonagem->bindParam(':nome_personagem', $oferta['nome'], PDO::PARAM_STR); // Nome do personagem

    if ($stmtTransferirPersonagem->execute()) {
        echo "Personagem {$oferta['nome']} transferido para {$_SESSION['user_name']} com sucesso.<br>";
    } else {
        echo "Erro ao transferir personagem: " . $stmtTransferirPersonagem->errorInfo()[2] . "<br>";
    }
}


    // xxxxxxxxxxxxxx   xxxxxxxxxxxxxxxx

    // xxxxxxxxxxxxxx   xxxxxxxxxxxxxxxx
    // xxxxxxxxxxxxxx   xxxxxxxxxxxxxxxx
    // xxxxxxxxxxxxxx   xxxxxxxxxxxxxxxx
    // xxxxxxxxxxxxxx   xxxxxxxxxxxxxxxx
        // Apagar ordem de compra

        // Verifica se a oferta é uma ficha ou personagem
// Verifica se a oferta é uma ficha ou personagem
if ($oferta['tipo'] == 'ficha' || $oferta['tipo'] == 'personagem') {
    // Define o tipo da ordem apagada
    $tipoApagado = ($oferta['tipo'] == 'ficha') ? "Ordem de venda de ficha apagada" : "Ordem de venda de personagem apagada";

    // Monta a informação da ordem apagada
    $informacaoApagado = "Foi apagada a ordem de venda de " . ($oferta['tipo'] == 'ficha' ? 'ficha' : 'personagem') . 
                         ", de id: {$oferta['id']}, do jogador {$oferta['jogador']}, " . 
                         ($oferta['tipo'] == 'ficha' ? "quantidade: {$oferta['quantidade']}, " : "personagem: {$oferta['nome']}, ") . 
                         "valor: R$ " . number_format($oferta['valor'], 2, ',', '.') . ", data: {$oferta['dataehora']}; " . 
                         "Devido ter sido comprada automaticamente, de uma ordem de compra do jogador {$_SESSION['user_name']}, " . 
                         "pedindo $quantidade NFT's por um valor de R$ " . number_format($valor, 2, ',', '.') . ", na data de " . date('Y-m-d H:i:s') . ".";

    // Insere os dados na tabela apagados
    $sqlApagados = "INSERT INTO apagados (tipo, informacao, origem, dataehora) 
                    VALUES (:tipo, :informacao, :origem, :dataehora)";
    $stmtApagados = $pdo->prepare($sqlApagados);
    $stmtApagados->bindValue(':tipo', $tipoApagado, PDO::PARAM_STR); // Usando bindValue
    $stmtApagados->bindValue(':informacao', $informacaoApagado, PDO::PARAM_STR); // Usando bindValue
    $stmtApagados->bindValue(':origem', 'Ordem de compra', PDO::PARAM_STR); // Usando bindValue
    $stmtApagados->bindValue(':dataehora', date('Y-m-d H:i:s'), PDO::PARAM_STR); // Usando bindValue

    if ($stmtApagados->execute()) {
        echo "Ordem de venda de " . ($oferta['tipo'] == 'ficha' ? 'ficha' : 'personagem') . " registrada na tabela apagados.<br>";
    } else {
        echo "Erro ao registrar ordem de venda apagada: " . $stmtApagados->errorInfo()[2] . "<br>";
    }

    // Apaga a ordem de venda da tabela correspondente
    $tabelaOrdemVenda = 'ordem_vendas';
    $sqlApagarOrdem = "DELETE FROM $tabelaOrdemVenda WHERE id = :id_ordem";
    $stmtApagarOrdem = $pdo->prepare($sqlApagarOrdem);
    $stmtApagarOrdem->bindValue(':id_ordem', $oferta['id'], PDO::PARAM_INT); // Usando bindValue

    if ($stmtApagarOrdem->execute()) {
        echo "Ordem de venda de " . ($oferta['tipo'] == 'ficha' ? 'ficha' : 'personagem') . " apagada com sucesso.<br>";
    } else {
        echo "Erro ao apagar ordem de venda: " . $stmtApagarOrdem->errorInfo()[2] . "<br>";
    }
}





    // ########### fim fo looping#############    
    }



    // xxxxxxxxxxxxxx   xxxxxxxxxxxxxxxx
                // Inicializa variáveis para o relatório
                $txt1 = "O jogador {$_SESSION['user_name']} executou uma ordem de compra, pedindo $quantidade NFT pelo valor de R$ " . number_format($valor, 2, ',', '.') . ".\n";

                $txt2 = "";
                $txt3 = "";
                $txt4 = "";


                // Verifica se houve transações
                if ($quantidadeDisponivel >= 1 && count($resultados) > 0) {
                    
                                                            
                    $txt2 = "Havia $quantidadeDisponivel ordens de venda disponíveis.\n";

                    // Loop para detalhar cada transação
                    foreach ($resultados as $index => $oferta) {
                        $quantidadeComprada = ($oferta['tipo'] == 'ficha') ? min($oferta['quantidade'], $quantidadeDesejada) : 1;
                        $valorTransacao = bcmul($oferta['valor'], $quantidadeComprada, 2);

                        $txt2 .= "A " . ($index + 1) . "° transação foi de $quantidadeComprada " . 
                                ($oferta['tipo'] == 'ficha' ? 'fichas' : 'personagem (' . $oferta['nome'] . ')') . 
                                " a um valor de R$ " . number_format($oferta['valor'], 2, ',', '.') . 
                                " do jogador {$oferta['jogador']}, criada na data {$oferta['dataehora']}.\n";   }

                    // Verifica se a quantidade total da ordem não foi suprida
                    if ($quantidadeFaltante > 0) {
                        $txt3 = "Ficou faltando $quantidadeFaltante para completar a ordem de compra, sendo listado o pedido de $quantidadeFaltante NFT's nas ordens de compra.\n";
                    }
                } else {
                    // Se não houve transações disponíveis
                    $txt4 = "Não havia nenhuma ficha/personagem sendo vendido num valor compatível, então foi criada uma ordem de venda pedindo $quantidade de NFT's num valor de R$ " . number_format($valor, 2, ',', '.') . ".\n";
                }

                // Junta todos os textos em uma única mensagem
                $relatorioFinal = $txt1 . $txt2 . $txt3 . $txt4;

                // Exibe o relatório
                echo "<pre>$relatorioFinal</pre>";
                    // Exibe o número de ofertas encontradas e o total gasto
                    echo "<br><b>Total de ofertas encontradas:</b> $ofertasEncontradas<br>";
                    echo "<b>Total a ser gasto:</b> R$ " . number_format($totalGasto, 2, ',', '.') . "<br>";
                } else {
                    echo "Não há ofertas disponíveis no valor que você está procurando.";
                }




                // xxxxxxxxxxxxx xxxxxxxxxxxxxxxxxx
                // Prepara os dados para inserção na tabela infossistema
                $informacao = $relatorioFinal; // O texto completo do relatório
                $p1 = $_SESSION['user_name']; // O jogador logado (comprador)
                $p2 = implode(", ", array_column($resultados, 'jogador')); // Todos os nomes dos vendedores separados por vírgula
                $origem = "Ordem de compra"; // Origem da informação
                $dataehora = date('Y-m-d H:i:s'); // Data e hora atual

                // Query para inserir os dados na tabela infossistema
                $sqlInfossistema = "INSERT INTO infossistema (informacao, p1, p2, origem, dataehora) 
                                    VALUES (:informacao, :p1, :p2, :origem, :dataehora)";
                $stmtInfossistema = $pdo->prepare($sqlInfossistema);
                $stmtInfossistema->bindParam(':informacao', $informacao, PDO::PARAM_STR);
                $stmtInfossistema->bindParam(':p1', $p1, PDO::PARAM_STR);
                $stmtInfossistema->bindParam(':p2', $p2, PDO::PARAM_STR);
                $stmtInfossistema->bindParam(':origem', $origem, PDO::PARAM_STR);
                $stmtInfossistema->bindParam(':dataehora', $dataehora, PDO::PARAM_STR);

                // Executa a inserção
                if ($stmtInfossistema->execute()) {
                    echo "Relatório enviado para o sistema com sucesso.<br>";
                } else {
                    echo "Erro ao enviar relatório para o sistema: " . $stmtInfossistema->errorInfo()[2] . "<br>";
                }

// xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxxx
// akii

// akii
// xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxxx

exit;
// xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxxx
// criar as ordens que não acharam vendedor compativel vv
// apagar ordens de vendas e fichas
        //transferir fichas vv
        //transferir personagens vv
//transferencia na mempool vv
//sistema vv
//notificação vv

//-----
//se não tiver ordens de venda disponiveis, criar a ordem



// xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxxx

// xxxxxxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxxx


    // Inserir os valores na tabela "ordens_compra"
    $sqlOrdemCompra = "INSERT INTO ordens_compra (quantidade, valor, wallet, user, dataehora) VALUES (:quantidade, :valor, :userwallet, :user_id, :dataehora)";
    $stmtOrdemCompra = $pdo->prepare($sqlOrdemCompra);
    $stmtOrdemCompra->bindParam(':quantidade', $quantidade, PDO::PARAM_INT);
    $stmtOrdemCompra->bindParam(':valor', $valor, PDO::PARAM_STR);
    $stmtOrdemCompra->bindParam(':userwallet', $userwallet, PDO::PARAM_STR);
    $stmtOrdemCompra->bindParam(':user_id', $user_id, PDO::PARAM_STR);
    $stmtOrdemCompra->bindParam(':dataehora', $dataehora, PDO::PARAM_STR);

    if ($stmtOrdemCompra->execute()) {
        // Dados da ordem de compra inseridos com sucesso
    } else {
        echo "Erro ao criar a ordem de compra: " . $stmtOrdemCompra->errorInfo()[2];
    }

    // Inserir os valores na tabela "mempool"
    $sqlMempool = "INSERT INTO mempool (remetente, valor, dataehora, referencia) VALUES (:remetente, :valor, :dataehora, :referencia)";
    $stmtMempool = $pdo->prepare($sqlMempool);
    $stmtMempool->bindParam(':remetente', $userwallet, PDO::PARAM_STR);
    $stmtMempool->bindParam(':valor', $qntxvalor, PDO::PARAM_STR);
    $stmtMempool->bindParam(':dataehora', $dataehora, PDO::PARAM_STR);
    $referencia = "Ordem de comprar $quantidade por R$ $valor (R$ $qntxvalor) criada em $dataehora";
    $stmtMempool->bindParam(':referencia', $referencia, PDO::PARAM_STR);

    if ($stmtMempool->execute()) {
        // Dados inseridos na tabela mempool com sucesso
    } else {
        echo "Erro ao inserir dados na tabela mempool: " . $stmtMempool->errorInfo()[2];
    }

    $_SESSION['msg'] = "Ordem de compra de $quantidade unidades, por R$ $valor foi criada com sucesso.";
    header("Location: ordenscompra.php");
    exit;
}
?>
